%{

#include "gram.h"
#include "gram.tab.h"
#include <ctype.h>

#define RETW(x) count_lines(); strcpy (yylval.token, yytext); return (x) ;
#define RET(x) count_lines(); delete_white_space () ; return (x); 
#undef yywrap

int			yylook () ;
int			yyreject () ;
int			yyback () ;
extern	int		lineno ;
extern	YYSTYPE		yylval ;
extern	int		pass ;
extern	char		white[] ;

%}

digit			[0-9]
number			{digit}+
alpha			[a-zA-Z_]
alphanum		({alpha}|{digit})

exponent		[eE][-+]?{number}
fract_const		({digit}*"."{number})|({number}".")
float_const		(({fract_const}{exponent}?)|({number}{exponent}))[FfLl]?
integer_suffix_opt	([uU]?[lL]?)|([lL][uU])
decimal_const		[1-9]{digit}*{integer_suffix_opt}
octal_const		"0"[0-7]*{integer_suffix_opt}
hex_const		"0"[xX][0-9a-fA-F]+{integer_suffix_opt}
decimal			{digit}?	

simple_escape		[abfnrtv'"?\\]
octal_escape		[0-7]{1,3}
hex_escape		"x"[0-9a-fA-F]+
escape_sequence		[\\]({simple_escape}|{octal_escape}|{hex_escape})
c_char			[^'\\\n]|{escape_sequence}
s_char			[^"\\\n]|{escape_sequence}

h_tab			[\t]
form_feed		[\f]
v_tab			[\013]
c_return		[\r]
n_line			[\n]
horizontal_white	([ ]|{h_tab})
com			"/*"[^"*/"]*"*/"
w_space			({h_tab}|{form_feed}|{v_tab}|{c_return}|{n_line}|{horizontal_white}|{com})
ws			{w_space}*

algorithm		"%algorithm"
decls			"%decls"
desc_decl		"%descriptor"
descriptor		"D"{number}
irule			"%irule"
header                  "%header"
helper			"%helper"
layer			"%layer"
layer_stacking		"%optimizer"
operator		"%operator"
relation		"F"{number}
stream			"S"{number}
trule			"%trule"

%%

    strcpy (white, "") ;

"root"{ws}                  { RETW (ROOT) }
^{layer}{ws}                { RETW (LAYER) }
^{layer_stacking}           { RETW (LAYER_STACKING) }
^{operator}{ws}             { RETW (OPERATOR) }
^{algorithm}{ws}            { RETW (ALGORITHM) }
^{decls}{ws}                { RETW (DECLS) }
^{helper}{ws}               { RETW (HELPER) }
^{header}{ws}               { RETW (HEADER) }
^{trule}{ws}                { RETW (TRULE) }
^{irule}{ws}                { RETW (IRULE) }
"("{ws}                     { RETW (LEFT_PAREN) }
")"{ws}                     { RETW (RIGHT_PAREN) }
"{{"{ws}                    { RETW (LEFT_BRACES) }
"}}"{ws}                    { RETW (RIGHT_BRACES) }
":"{ws}                     { RETW (COLON) }
","{ws}                     { RETW (COMMA) }
"."{ws}                     { RETW (DOT) }
";"{ws}                     { RETW (SEMICOLON) }
"["{ws}                     { RETW (LEFT_BRACKET) }
"]"{ws}                     { RETW (RIGHT_BRACKET) }
"*"{ws}                     { RETW (STAR) }
"=>"{ws}                    { RETW (REWRITE) }
"->"{ws}                    { RETW (POINTER) }
{desc_decl}{ws}             { RETW (DESC_DECL) }
"dcopy"{ws}                 { RETW (DCOPY) }
{stream}{ws}                { RETW (STREAM) }
{relation}{ws}              { RETW (RELATION) }
{descriptor}{ws}            { RETW (DESCRIPTOR) }

{decimal_const}{ws}         { RETW (NUMBER) }
{octal_const}{ws}           { RETW (NUMBER) }
{hex_const}{ws}             { RETW (NUMBER) }
{float_const}{ws}           { RETW (NUMBER) }

"/*"                        { comment() ; }
"#define"{ws}               { RETW (POUND_DEFINE) }
"#include"{ws}              { RETW (POUND_INCLUDE) }
"#line"{ws}                 { RETW (POUND_LINE) }
"#undef"{ws}                { RETW (POUND_UNDEF) }
"#if"{ws}                   { RETW (POUND_IF) }
"#ifndef"{ws}               { RETW (POUND_IFNDEF) }
"#elif"{ws}                 { RETW (POUND_ELIF) }
"#else"{ws}                 { RETW (POUND_ELSE) }
"#endif"{ws}                { RETW (POUND_ENDIF) }
"{"{ws}                     { RETW (LITERAL) }
"}"{ws}                     { RETW (LITERAL) }
"'"{ws}                     { RETW (LITERAL) }
"&"{ws}                     { RETW (BINOP) }
"+"{ws}                     { RETW (BINOP) }
"-"{ws}                     { RETW (BINOP) }
"~"{ws}                     { RETW (UNOP) }
"!"{ws}                     { RETW (EXCLAIM) }
"/"{ws}                     { RETW (BINOP) }
"%"{ws}                     { RETW (BINOP) }
"%%"{ws}                    { RETW (LITERAL) }
"<"{ws}                     { RETW (BINOP) }
">"{ws}                     { RETW (BINOP) }
"^"{ws}                     { RETW (BINOP) }
"|"{ws}                     { RETW (BINOP) }
"?"{ws}                     { RETW (LITERAL) }
"="{ws}                     { RETW (ASGNOP) }
"++"{ws}                    { RETW (UNOP) }
"--"{ws}                    { RETW (UNOP) }
"<<"{ws}                    { RETW (BINOP) }
">>"{ws}                    { RETW (BINOP) }
"<="{ws}                    { RETW (BINOP) }
">="{ws}                    { RETW (BINOP) }
"=="{ws}                    { RETW (BINOP) }
"!="{ws}                    { RETW (BINOP) }
"&&"{ws}                    { RETW (BINOP) }
"||"{ws}                    { RETW (BINOP) }
"*="{ws}                    { RETW (ASGNOP) }
"/="{ws}                    { RETW (ASGNOP) }
"%="{ws}                    { RETW (ASGNOP) }
"+="{ws}                    { RETW (ASGNOP) }
"-="{ws}                    { RETW (ASGNOP) }
"<<="{ws}                   { RETW (ASGNOP) }
">>="{ws}                   { RETW (ASGNOP) }
"&="{ws}                    { RETW (ASGNOP) }
"^="{ws}                    { RETW (ASGNOP) }
"|="{ws}                    { RETW (ASGNOP) }
\"(\\.|[^\\"])*\"{ws}       { RETW (LITERAL) }
\\{ws}                      { RETW (LITERAL) }

{alpha}{alphanum}*{ws}      { RETW (IDENTIFIER) }

{horizontal_white}+         { }
({v_tab}|{form_feed}|{c_return}|{n_line})  { lineno++ ; }

%%

/* Count the number of newlines in yytext. */
count_lines()
{
   int i = 0 ;

   while (yytext[i] != '\0')
   {
       if (yytext[i] == '\n')
           lineno++ ;
       i++ ;
   }
}

comment()
{
	char c, c1 ;
	char s[1] ;

loop:
	while ((c = input()) != '*' && c != 0)
	{
		if (c == '\n') lineno++ ;
		sprintf (s, "%c", c) ;
	}

	if ((c1 = input()) != '/' && c != 0)
	{
		unput(c1) ;
		goto loop ;
	}
}

yyerror (text)
char text [] ;
{
	fprintf (stderr," %s: last token was \"%s\", line %d\n",
			text, yytext, lineno) ;
	exit (-1) ;
}

int yywrap ()
{
	return (1) ;
}
